// CtrlCard.h: interface for the CCtrlCard class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_CTRLCARD_H__792BC8C3_F372_497B_B0A1_6F065F0C19DD__INCLUDED_)
#define AFX_CTRLCARD_H__792BC8C3_F372_497B_B0A1_6F065F0C19DD__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

/*********************** Motion control module ******************** 
For simplicity, quickly and easily develop a common good, scalable, 
and easy maintenance of application systems, 
we control the library card will be the basis of all the library functions are classified package.
 The following example uses a motion control card 
****************************************** **************/




#define  MAXAXIS  4    //The maximum number of axes

class CCtrlCard  
{
public:
	int Get_AxisInfo(int dev_num,long LogPos[],long ActPos[],long Speed[] );
	int Setup_HardStop(int value, int logic);
	int Setup_Stop1Mode(int axis, int value, int logic);
	int Setup_Stop0Mode(int axis, int value, int logic);
	int Setup_LimitMode(int axis, int value1, int value2, int logic);
	int Setup_PulseMode(int axis, int value);
	int Setup_Pos(int axis, long pos, int mode);
	int Write_Output(int number, int value);
	int Read_Input(int number, int &value);
	int Get_CurrentInf(int axis, long &LogPos, long &ActPos, long &Speed);
	int Get_Status(int axis, int &value, int mode);
	int StopRun(int axis, int mode);
	int Interp_Move4(long value1, long value2, long value3, long value4);
	int Interp_Move3(int axis1, int axis2, int axis3, long value1, long value2, long value3);
	int Interp_Move2(int axis1, int axis2, long value1, long value2);
	int Axis_Pmove(int axis ,long value);	
	int Axis_Cmove(int axis ,long value);
	int Setup_Speed(int axis ,long startv ,long speed ,long  add );
	int Init_Board(int dec_num);
	CCtrlCard();
	int Result;         //Return Value

};

#endif // !defined(AFX_CTRLCARD_H__792BC8C3_F372_497B_B0A1_6F065F0C19DD__INCLUDED_)
